<?php

namespace MeuMouse\Flexify_Checkout\Validations;

// Exit if accessed directly.
defined('ABSPATH') || exit;

/**
 * Class for register country codes on format ISO 3166
 *
 * @since 5.0.0
 * @package MeuMouse.com
 */
class ISO3166 {

    /**
     * ISO 3166 alpha-2 country codes
     * 
     * @since 1.0.0
     * @version 5.0.0
     * @return array
     */
    public static function country_codes() {
        return apply_filters( 'Flexify_Checkout/Validations/ISO3166', array(
            'none' => esc_html( 'Nenhum', 'flexify-checkout-for-woocommerce' ),
            'AF' => esc_html( 'Afghanistan', 'flexify-checkout-for-woocommerce' ),
            'AL' => esc_html( 'Albania', 'flexify-checkout-for-woocommerce' ),
            'DZ' => esc_html( 'Algeria', 'flexify-checkout-for-woocommerce' ),
            'AS' => esc_html( 'American Samoa', 'flexify-checkout-for-woocommerce' ),
            'AD' => esc_html( 'Andorra', 'flexify-checkout-for-woocommerce' ),
            'AO' => esc_html( 'Angola', 'flexify-checkout-for-woocommerce' ),
            'AI' => esc_html( 'Anguilla', 'flexify-checkout-for-woocommerce' ),
            'AQ' => esc_html( 'Antarctica', 'flexify-checkout-for-woocommerce' ),
            'AG' => esc_html( 'Antigua and Barbuda', 'flexify-checkout-for-woocommerce' ),
            'AR' => esc_html( 'Argentina', 'flexify-checkout-for-woocommerce' ),
            'AM' => esc_html( 'Armenia', 'flexify-checkout-for-woocommerce' ),
            'AW' => esc_html( 'Aruba', 'flexify-checkout-for-woocommerce' ),
            'AU' => esc_html( 'Australia', 'flexify-checkout-for-woocommerce' ),
            'AT' => esc_html( 'Austria', 'flexify-checkout-for-woocommerce' ),
            'AZ' => esc_html( 'Azerbaijan', 'flexify-checkout-for-woocommerce' ),
            'BS' => esc_html( 'Bahamas', 'flexify-checkout-for-woocommerce' ),
            'BH' => esc_html( 'Bahrain', 'flexify-checkout-for-woocommerce' ),
            'BD' => esc_html( 'Bangladesh', 'flexify-checkout-for-woocommerce' ),
            'BB' => esc_html( 'Barbados', 'flexify-checkout-for-woocommerce' ),
            'BY' => esc_html( 'Belarus', 'flexify-checkout-for-woocommerce' ),
            'BE' => esc_html( 'Belgium', 'flexify-checkout-for-woocommerce' ),
            'BZ' => esc_html( 'Belize', 'flexify-checkout-for-woocommerce' ),
            'BJ' => esc_html( 'Benin', 'flexify-checkout-for-woocommerce' ),
            'BM' => esc_html( 'Bermuda', 'flexify-checkout-for-woocommerce' ),
            'BT' => esc_html( 'Bhutan', 'flexify-checkout-for-woocommerce' ),
            'BO' => esc_html( 'Bolivia', 'flexify-checkout-for-woocommerce' ),
            'BQ' => esc_html( 'Bonaire, Sint Eustatius and Saba', 'flexify-checkout-for-woocommerce' ),
            'BA' => esc_html( 'Bosnia and Herzegovina', 'flexify-checkout-for-woocommerce' ),
            'BW' => esc_html( 'Botswana', 'flexify-checkout-for-woocommerce' ),
            'BV' => esc_html( 'Bouvet Island', 'flexify-checkout-for-woocommerce' ),
            'BR' => esc_html( 'Brasil', 'flexify-checkout-for-woocommerce' ),
            'IO' => esc_html( 'British Indian Ocean Territory', 'flexify-checkout-for-woocommerce' ),
            'BN' => esc_html( 'Brunei Darussalam', 'flexify-checkout-for-woocommerce' ),
            'BG' => esc_html( 'Bulgaria', 'flexify-checkout-for-woocommerce' ),
            'BF' => esc_html( 'Burkina Faso', 'flexify-checkout-for-woocommerce' ),
            'BI' => esc_html( 'Burundi', 'flexify-checkout-for-woocommerce' ),
            'CV' => esc_html( 'Cabo Verde', 'flexify-checkout-for-woocommerce' ),
            'KH' => esc_html( 'Cambodia', 'flexify-checkout-for-woocommerce' ),
            'CM' => esc_html( 'Cameroon', 'flexify-checkout-for-woocommerce' ),
            'CA' => esc_html( 'Canada', 'flexify-checkout-for-woocommerce' ),
            'KY' => esc_html( 'Cayman Islands', 'flexify-checkout-for-woocommerce' ),
            'CF' => esc_html( 'Central African Republic', 'flexify-checkout-for-woocommerce' ),
            'TD' => esc_html( 'Chad', 'flexify-checkout-for-woocommerce' ),
            'CL' => esc_html( 'Chile', 'flexify-checkout-for-woocommerce' ),
            'CN' => esc_html( 'China', 'flexify-checkout-for-woocommerce' ),
            'CX' => esc_html( 'Christmas Island', 'flexify-checkout-for-woocommerce' ),
            'CC' => esc_html( 'Cocos (Keeling) Islands', 'flexify-checkout-for-woocommerce' ),
            'CO' => esc_html( 'Colombia', 'flexify-checkout-for-woocommerce' ),
            'KM' => esc_html( 'Comoros', 'flexify-checkout-for-woocommerce' ),
            'CD' => esc_html( 'Democratic Republic of the Congo', 'flexify-checkout-for-woocommerce' ),
            'CG' => esc_html( 'Republic of the Congo', 'flexify-checkout-for-woocommerce' ),
            'CK' => esc_html( 'Cook Islands', 'flexify-checkout-for-woocommerce' ),
            'CR' => esc_html( 'Costa Rica', 'flexify-checkout-for-woocommerce' ),
            'HR' => esc_html( 'Croatia', 'flexify-checkout-for-woocommerce' ),
            'CU' => esc_html( 'Cuba', 'flexify-checkout-for-woocommerce' ),
            'CW' => esc_html( 'Curaçao', 'flexify-checkout-for-woocommerce' ),
            'CY' => esc_html( 'Cyprus', 'flexify-checkout-for-woocommerce' ),
            'CZ' => esc_html( 'Czechia', 'flexify-checkout-for-woocommerce' ),
            'CI' => esc_html( 'Côte d`Ivoire', 'flexify-checkout-for-woocommerce' ),
            'DK' => esc_html( 'Denmark', 'flexify-checkout-for-woocommerce' ),
            'DJ' => esc_html( 'Djibouti', 'flexify-checkout-for-woocommerce' ),
            'DM' => esc_html( 'Dominica', 'flexify-checkout-for-woocommerce' ),
            'DO' => esc_html( 'Dominican Republic', 'flexify-checkout-for-woocommerce' ),
            'EC' => esc_html( 'Ecuador', 'flexify-checkout-for-woocommerce' ),
            'EG' => esc_html( 'Egypt', 'flexify-checkout-for-woocommerce' ),
            'SV' => esc_html( 'El Salvador', 'flexify-checkout-for-woocommerce' ),
            'GQ' => esc_html( 'Equatorial Guinea', 'flexify-checkout-for-woocommerce' ),
            'ER' => esc_html( 'Eritrea', 'flexify-checkout-for-woocommerce' ),
            'EE' => esc_html( 'Estonia', 'flexify-checkout-for-woocommerce' ),
            'SZ' => esc_html( 'Eswatini', 'flexify-checkout-for-woocommerce' ),
            'ET' => esc_html( 'Ethiopia', 'flexify-checkout-for-woocommerce' ),
            'FK' => esc_html( 'Falkland Islands [Malvinas]', 'flexify-checkout-for-woocommerce' ),
            'FO' => esc_html( 'Faroe Islands', 'flexify-checkout-for-woocommerce' ),
            'FJ' => esc_html( 'Fiji', 'flexify-checkout-for-woocommerce' ),
            'FI' => esc_html( 'Finland', 'flexify-checkout-for-woocommerce' ),
            'FR' => esc_html( 'France', 'flexify-checkout-for-woocommerce' ),
            'GF' => esc_html( 'French Guiana', 'flexify-checkout-for-woocommerce' ),
            'PF' => esc_html( 'French Polynesia', 'flexify-checkout-for-woocommerce' ),
            'TF' => esc_html( 'French Southern Territories', 'flexify-checkout-for-woocommerce' ),
            'GA' => esc_html( 'Gabon', 'flexify-checkout-for-woocommerce' ),
            'GM' => esc_html( 'Gambia', 'flexify-checkout-for-woocommerce' ),
            'GE' => esc_html( 'Georgia', 'flexify-checkout-for-woocommerce' ),
            'DE' => esc_html( 'Germany', 'flexify-checkout-for-woocommerce' ),
            'GH' => esc_html( 'Ghana', 'flexify-checkout-for-woocommerce' ),
            'GI' => esc_html( 'Gibraltar', 'flexify-checkout-for-woocommerce' ),
            'GR' => esc_html( 'Greece', 'flexify-checkout-for-woocommerce' ),
            'GL' => esc_html( 'Greenland', 'flexify-checkout-for-woocommerce' ),
            'GD' => esc_html( 'Grenada', 'flexify-checkout-for-woocommerce' ),
            'GP' => esc_html( 'Guadeloupe', 'flexify-checkout-for-woocommerce' ),
            'GU' => esc_html( 'Guam', 'flexify-checkout-for-woocommerce' ),
            'GT' => esc_html( 'Guatemala', 'flexify-checkout-for-woocommerce' ),
            'GG' => esc_html( 'Guernsey', 'flexify-checkout-for-woocommerce' ),
            'GN' => esc_html( 'Guinea', 'flexify-checkout-for-woocommerce' ),
            'GW' => esc_html( 'Guinea-Bissau', 'flexify-checkout-for-woocommerce' ),
            'GY' => esc_html( 'Guyana', 'flexify-checkout-for-woocommerce' ),
            'HT' => esc_html( 'Haiti', 'flexify-checkout-for-woocommerce' ),
            'HM' => esc_html( 'Heard Island and McDonald Islands', 'flexify-checkout-for-woocommerce' ),
            'VA' => esc_html( 'Holy See', 'flexify-checkout-for-woocommerce' ),
            'HN' => esc_html( 'Honduras', 'flexify-checkout-for-woocommerce' ),
            'HK' => esc_html( 'Hong Kong', 'flexify-checkout-for-woocommerce' ),
            'HU' => esc_html( 'Hungary', 'flexify-checkout-for-woocommerce' ),
            'IS' => esc_html( 'Iceland', 'flexify-checkout-for-woocommerce' ),
            'IN' => esc_html( 'India', 'flexify-checkout-for-woocommerce' ),
            'ID' => esc_html( 'Indonesia', 'flexify-checkout-for-woocommerce' ),
            'IR' => esc_html( 'Iran', 'flexify-checkout-for-woocommerce' ),
            'IQ' => esc_html( 'Iraq', 'flexify-checkout-for-woocommerce' ),
            'IE' => esc_html( 'Ireland', 'flexify-checkout-for-woocommerce' ),
            'IM' => esc_html( 'Isle of Man', 'flexify-checkout-for-woocommerce' ),
            'IL' => esc_html( 'Israel', 'flexify-checkout-for-woocommerce' ),
            'IT' => esc_html( 'Italy', 'flexify-checkout-for-woocommerce' ),
            'JM' => esc_html( 'Jamaica', 'flexify-checkout-for-woocommerce' ),
            'JP' => esc_html( 'Japan', 'flexify-checkout-for-woocommerce' ),
            'JE' => esc_html( 'Jersey', 'flexify-checkout-for-woocommerce' ),
            'JO' => esc_html( 'Jordan', 'flexify-checkout-for-woocommerce' ),
            'KZ' => esc_html( 'Kazakhstan', 'flexify-checkout-for-woocommerce' ),
            'KE' => esc_html( 'Kenya', 'flexify-checkout-for-woocommerce' ),
            'KI' => esc_html( 'Kiribati', 'flexify-checkout-for-woocommerce' ),
            'KP' => esc_html( 'Democratic Peoples Republic of Korea', 'flexify-checkout-for-woocommerce' ),
            'KR' => esc_html( 'Republic of Korea', 'flexify-checkout-for-woocommerce' ),
            'KW' => esc_html( 'Kuwait', 'flexify-checkout-for-woocommerce' ),
            'KG' => esc_html( 'Kyrgyzstan', 'flexify-checkout-for-woocommerce' ),
            'LA' => esc_html( 'Lao', 'flexify-checkout-for-woocommerce' ),
            'LV' => esc_html( 'Latvia', 'flexify-checkout-for-woocommerce' ),
            'LB' => esc_html( 'Lebanon', 'flexify-checkout-for-woocommerce' ),
            'LS' => esc_html( 'Lesotho', 'flexify-checkout-for-woocommerce' ),
            'LR' => esc_html( 'Liberia', 'flexify-checkout-for-woocommerce' ),
            'LY' => esc_html( 'Libya', 'flexify-checkout-for-woocommerce' ),
            'LI' => esc_html( 'Liechtenstein', 'flexify-checkout-for-woocommerce' ),
            'LT' => esc_html( 'Lithuania', 'flexify-checkout-for-woocommerce' ),
            'LU' => esc_html( 'Luxembourg', 'flexify-checkout-for-woocommerce' ),
            'MO' => esc_html( 'Macao', 'flexify-checkout-for-woocommerce' ),
            'MG' => esc_html( 'Madagascar', 'flexify-checkout-for-woocommerce' ),
            'MW' => esc_html( 'Malawi', 'flexify-checkout-for-woocommerce' ),
            'MY' => esc_html( 'Malaysia', 'flexify-checkout-for-woocommerce' ),
            'MV' => esc_html( 'Maldives', 'flexify-checkout-for-woocommerce' ),
            'ML' => esc_html( 'Mali', 'flexify-checkout-for-woocommerce' ),
            'MT' => esc_html( 'Malta', 'flexify-checkout-for-woocommerce' ),
            'MH' => esc_html( 'Marshall Islands', 'flexify-checkout-for-woocommerce' ),
            'MQ' => esc_html( 'Martinique', 'flexify-checkout-for-woocommerce' ),
            'MR' => esc_html( 'Mauritania', 'flexify-checkout-for-woocommerce' ),
            'MU' => esc_html( 'Mauritius', 'flexify-checkout-for-woocommerce' ),
            'YT' => esc_html( 'Mayotte', 'flexify-checkout-for-woocommerce' ),
            'MX' => esc_html( 'Mexico', 'flexify-checkout-for-woocommerce' ),
            'FM' => esc_html( 'Micronesia', 'flexify-checkout-for-woocommerce' ),
            'MD' => esc_html( 'Moldova', 'flexify-checkout-for-woocommerce' ),
            'MC' => esc_html( 'Monaco', 'flexify-checkout-for-woocommerce' ),
            'MN' => esc_html( 'Mongolia', 'flexify-checkout-for-woocommerce' ),
            'ME' => esc_html( 'Montenegro', 'flexify-checkout-for-woocommerce' ),
            'MS' => esc_html( 'Montserrat', 'flexify-checkout-for-woocommerce' ),
            'MA' => esc_html( 'Morocco', 'flexify-checkout-for-woocommerce' ),
            'MZ' => esc_html( 'Mozambique', 'flexify-checkout-for-woocommerce' ),
            'MM' => esc_html( 'Myanmar', 'flexify-checkout-for-woocommerce' ),
            'NA' => esc_html( 'Namibia', 'flexify-checkout-for-woocommerce' ),
            'NR' => esc_html( 'Nauru', 'flexify-checkout-for-woocommerce' ),
            'NP' => esc_html( 'Nepal', 'flexify-checkout-for-woocommerce' ),
            'NL' => esc_html( 'Netherlands', 'flexify-checkout-for-woocommerce' ),
            'NC' => esc_html( 'New Caledonia', 'flexify-checkout-for-woocommerce' ),
            'NZ' => esc_html( 'New Zealand', 'flexify-checkout-for-woocommerce' ),
            'NI' => esc_html( 'Nicaragua', 'flexify-checkout-for-woocommerce' ),
            'NE' => esc_html( 'Niger', 'flexify-checkout-for-woocommerce' ),
            'NG' => esc_html( 'Nigeria', 'flexify-checkout-for-woocommerce' ),
            'NU' => esc_html( 'Niue', 'flexify-checkout-for-woocommerce' ),
            'NF' => esc_html( 'Norfolk Island', 'flexify-checkout-for-woocommerce' ),
            'MP' => esc_html( 'Northern Mariana Islands', 'flexify-checkout-for-woocommerce' ),
            'NO' => esc_html( 'Norway', 'flexify-checkout-for-woocommerce' ),
            'OM' => esc_html( 'Oman', 'flexify-checkout-for-woocommerce' ),
            'PK' => esc_html( 'Pakistan', 'flexify-checkout-for-woocommerce' ),
            'PW' => esc_html( 'Palau', 'flexify-checkout-for-woocommerce' ),
            'PS' => esc_html( 'Palestine, State of Israel', 'flexify-checkout-for-woocommerce' ),
            'PA' => esc_html( 'Panama', 'flexify-checkout-for-woocommerce' ),
            'PG' => esc_html( 'Papua New Guinea', 'flexify-checkout-for-woocommerce' ),
            'PY' => esc_html( 'Paraguay', 'flexify-checkout-for-woocommerce' ),
            'PE' => esc_html( 'Peru', 'flexify-checkout-for-woocommerce' ),
            'PH' => esc_html( 'Philippines', 'flexify-checkout-for-woocommerce' ),
            'PN' => esc_html( 'Pitcairn', 'flexify-checkout-for-woocommerce' ),
            'PL' => esc_html( 'Poland', 'flexify-checkout-for-woocommerce' ),
            'PT' => esc_html( 'Portugal', 'flexify-checkout-for-woocommerce' ),
            'PR' => esc_html( 'Puerto Rico', 'flexify-checkout-for-woocommerce' ),
            'QA' => esc_html( 'Qatar', 'flexify-checkout-for-woocommerce' ),
            'MK' => esc_html( 'Republic of North Macedonia', 'flexify-checkout-for-woocommerce' ),
            'RO' => esc_html( 'Romania', 'flexify-checkout-for-woocommerce' ),
            'RU' => esc_html( 'Russian Federation', 'flexify-checkout-for-woocommerce' ),
            'RW' => esc_html( 'Rwanda', 'flexify-checkout-for-woocommerce' ),
            'RE' => esc_html( 'Réunion', 'flexify-checkout-for-woocommerce' ),
            'BL' => esc_html( 'Saint Barthélemy', 'flexify-checkout-for-woocommerce' ),
            'SH' => esc_html( 'Saint Helena, Ascension and Tristan da Cunha', 'flexify-checkout-for-woocommerce' ),
            'KN' => esc_html( 'Saint Kitts and Nevis', 'flexify-checkout-for-woocommerce' ),
            'LC' => esc_html( 'Saint Lucia', 'flexify-checkout-for-woocommerce' ),
            'MF' => esc_html( 'Saint Martin', 'flexify-checkout-for-woocommerce' ),
            'PM' => esc_html( 'Saint Pierre and Miquelon', 'flexify-checkout-for-woocommerce' ),
            'VC' => esc_html( 'Saint Vincent and the Grenadines', 'flexify-checkout-for-woocommerce' ),
            'WS' => esc_html( 'Samoa', 'flexify-checkout-for-woocommerce' ),
            'SM' => esc_html( 'San Marino', 'flexify-checkout-for-woocommerce' ),
            'ST' => esc_html( 'Sao Tome and Principe', 'flexify-checkout-for-woocommerce' ),
            'SA' => esc_html( 'Saudi Arabia', 'flexify-checkout-for-woocommerce' ),
            'SN' => esc_html( 'Senegal', 'flexify-checkout-for-woocommerce' ),
            'RS' => esc_html( 'Serbia', 'flexify-checkout-for-woocommerce' ),
            'SC' => esc_html( 'Seychelles', 'flexify-checkout-for-woocommerce' ),
            'SL' => esc_html( 'Sierra Leone', 'flexify-checkout-for-woocommerce' ),
            'SG' => esc_html( 'Singapore', 'flexify-checkout-for-woocommerce' ),
            'SX' => esc_html( 'Sint Maarten', 'flexify-checkout-for-woocommerce' ),
            'SK' => esc_html( 'Slovakia', 'flexify-checkout-for-woocommerce' ),
            'SI' => esc_html( 'Slovenia', 'flexify-checkout-for-woocommerce' ),
            'SB' => esc_html( 'Solomon Islands', 'flexify-checkout-for-woocommerce' ),
            'SO' => esc_html( 'Somalia', 'flexify-checkout-for-woocommerce' ),
            'ZA' => esc_html( 'South Africa', 'flexify-checkout-for-woocommerce' ),
            'GS' => esc_html( 'South Georgia and the South Sandwich Islands', 'flexify-checkout-for-woocommerce' ),
            'SS' => esc_html( 'South Sudan', 'flexify-checkout-for-woocommerce' ),
            'ES' => esc_html( 'Spain', 'flexify-checkout-for-woocommerce' ),
            'LK' => esc_html( 'Sri Lanka', 'flexify-checkout-for-woocommerce' ),
            'SD' => esc_html( 'Sudan', 'flexify-checkout-for-woocommerce' ),
            'SR' => esc_html( 'Suriname', 'flexify-checkout-for-woocommerce' ),
            'SJ' => esc_html( 'Svalbard and Jan Mayen', 'flexify-checkout-for-woocommerce' ),
            'SE' => esc_html( 'Sweden', 'flexify-checkout-for-woocommerce' ),
            'CH' => esc_html( 'Switzerland', 'flexify-checkout-for-woocommerce' ),
            'SY' => esc_html( 'Syrian Arab Republic', 'flexify-checkout-for-woocommerce' ),
            'TW' => esc_html( 'Taiwan', 'flexify-checkout-for-woocommerce' ),
            'TJ' => esc_html( 'Tajikistan', 'flexify-checkout-for-woocommerce' ),
            'TZ' => esc_html( 'Tanzania, United Republic of Tanganyika', 'flexify-checkout-for-woocommerce' ),
            'TH' => esc_html( 'Thailand', 'flexify-checkout-for-woocommerce' ),
            'TL' => esc_html( 'Timor-Leste', 'flexify-checkout-for-woocommerce' ),
            'TG' => esc_html( 'Togo', 'flexify-checkout-for-woocommerce' ),
            'TK' => esc_html( 'Tokelau', 'flexify-checkout-for-woocommerce' ),
            'TO' => esc_html( 'Tonga', 'flexify-checkout-for-woocommerce' ),
            'TT' => esc_html( 'Trinidad and Tobago', 'flexify-checkout-for-woocommerce' ),
            'TN' => esc_html( 'Tunisia', 'flexify-checkout-for-woocommerce' ),
            'TR' => esc_html( 'Turkey', 'flexify-checkout-for-woocommerce' ),
            'TM' => esc_html( 'Turkmenistan', 'flexify-checkout-for-woocommerce' ),
            'TC' => esc_html( 'Turks and Caicos Islands', 'flexify-checkout-for-woocommerce' ),
            'TV' => esc_html( 'Tuvalu', 'flexify-checkout-for-woocommerce' ),
            'UG' => esc_html( 'Uganda', 'flexify-checkout-for-woocommerce' ),
            'UA' => esc_html( 'Ukraine', 'flexify-checkout-for-woocommerce' ),
            'AE' => esc_html( 'United Arab Emirates', 'flexify-checkout-for-woocommerce' ),
            'GB' => esc_html( 'United Kingdom of Great Britain and Northern Ireland', 'flexify-checkout-for-woocommerce' ),
            'UM' => esc_html( 'United States Minor Outlying Islands', 'flexify-checkout-for-woocommerce' ),
            'US' => esc_html( 'United States of America', 'flexify-checkout-for-woocommerce' ),
            'UY' => esc_html( 'Uruguay', 'flexify-checkout-for-woocommerce' ),
            'UZ' => esc_html( 'Uzbekistan', 'flexify-checkout-for-woocommerce' ),
            'VU' => esc_html( 'Vanuatu', 'flexify-checkout-for-woocommerce' ),
            'VE' => esc_html( 'Venezuela', 'flexify-checkout-for-woocommerce' ),
            'VN' => esc_html( 'Viet Nam', 'flexify-checkout-for-woocommerce' ),
            'VG' => esc_html( 'Virgin Islands (British)', 'flexify-checkout-for-woocommerce' ),
            'VI' => esc_html( 'Virgin Islands (U.S.)', 'flexify-checkout-for-woocommerce' ),
            'WF' => esc_html( 'Wallis and Futuna', 'flexify-checkout-for-woocommerce' ),
            'EH' => esc_html( 'Western Sahara', 'flexify-checkout-for-woocommerce' ),
            'YE' => esc_html( 'Yemen', 'flexify-checkout-for-woocommerce' ),
            'ZM' => esc_html( 'Zambia', 'flexify-checkout-for-woocommerce' ),
            'ZW' => esc_html( 'Zimbabwe', 'flexify-checkout-for-woocommerce' ),
            'AX' => esc_html( 'Åland Islands', 'flexify-checkout-for-woocommerce' ),
        ));
    }
}