<?php
/**
 * Renders the license activation page
 */
function atlt_render_license_page() {
    // Define constants at the top for better maintainability
    $text_domain = 'loco-translate-addon';
    $purchase_email = get_option('LocoAutomaticTranslateAddonPro_lic_email', get_bloginfo('admin_email'));
    
    // Escape early for security
    $admin_url = esc_url(admin_url('admin-post.php'));
    $purchase_email_escaped = esc_attr($purchase_email);
    ?>
    <div class="atlt-dashboard-license">
        <div class="atlt-dashboard-license-container">
            <div class="header">
                <h1>🔑 <?php _e('Activate License', $text_domain); ?></h1>
            </div>
            <div class="atlt-dashboard-license-form">
                <form method="post" action="<?php echo $admin_url; ?>">
                    <input type="hidden" name="action" value="atlt_activate_license"/>
                    <?php wp_nonce_field('atlt-license'); ?>
                    
                    <div class="license-field">
                        <label for="license_code"><?php esc_html_e('License Key', $text_domain); ?></label>
                        <input type="text" name="license_code" id="license_code" required 
                            placeholder="<?php esc_attr_e('xxxxxxxx-xxxxxxxx-xxxxxxxx-xxxxxxxx', $text_domain); ?>">
                    </div>
                    
                    <div class="license-field">
                        <label for="email"><?php esc_html_e('Email Address', $text_domain); ?></label>
                        <input type="email" name="email" id="email" required 
                            value="<?php echo $purchase_email_escaped; ?>">
                        <small><?php esc_html_e("Plugin updates news will be sent to this email. Don't worry, we hate spam.", $text_domain); ?></small>
                    </div>
                    
                    <button type="submit" class="button button-primary">
                        <?php _e('Activate License', $text_domain); ?>
                    </button>
                </form>

                <p class="activation-note">
                    <?php _e('Activate to receive automatic plugin updates and support.', $text_domain); ?>
                </p>

                <div class="atlt-dashboard-license-pro-container-buttons">
                    <p><?php esc_html_e('Want to know more about the license key?', $text_domain); ?></p>
                    <div class="btns">
                        <a href="https://locoaddon.com/my-account/" target="_blank" class="atlt-dashboard-btn">
                            <?php _e('Check Account', $text_domain); ?>
                        </a>
                        <a href="https://locoaddon.com/support/" target="_blank" class="atlt-dashboard-btn">
                            <?php _e('Contact Support', $text_domain); ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php
}

/**
 * Renders the license information page for Pro users
 * 
 * @param object|null $license_info License information object
 */
function atlt_render_license_page_pro($license_info = null) {
    $text_domain = 'loco-translate-addon';
    
    // Early return if invalid license info
    if (!$license_info) {
        $license_info = LocoAutomaticTranslateAddonProBase::GetRegisterInfo();
    }

    if (!is_object($license_info) || !isset($license_info->is_valid) || !isset($license_info->license_title) || !isset($license_info->expire_date)) {
        wp_die(__('Error: Invalid license information', $text_domain));
        return;
    }
    
    // Sanitize license key before masking
    $license_key = sanitize_text_field(get_option('LocoAutomaticTranslateAddonPro_lic_Key', ''));
    $masked_key = !empty($license_key) ? 
        esc_html(substr($license_key, 0, 8) . '-XXXXXXXX-XXXXXXXX-' . substr($license_key, -8)) :
        '';
    
    $admin_url = esc_url(admin_url('admin-post.php'));
?>
    <div class="atlt-dashboard-license">
        <div class="atlt-dashboard-license-pro-container">
            <h1>🔒 <?php _e('Your License Info', $text_domain); ?></h1>
            <ul>
                <li><strong><?php esc_html_e('Status:', $text_domain); ?></strong> 
                    <span class="validity">
                        <?php if ($license_info->is_valid): ?>
                            <strong>✅ <?php esc_html_e('Valid', $text_domain); ?></strong>
                        <?php else: ?>
                            <strong>❌ <?php esc_html_e('Invalid', $text_domain); ?></strong>
                        <?php endif; ?>
                    </span>
                </li>
                <li><strong><?php _e('License Type:', $text_domain); ?></strong> <span class="license-type"><?php echo esc_html($license_info->license_title); ?></span></li>
                <li><strong><?php _e('Plugin Updates & Support Validity:', $text_domain); ?></strong> <span class="validity"><?php echo esc_html($license_info->expire_date); ?></span></li>
                <li><strong><?php _e('Your License Key:', $text_domain); ?></strong> <span class="license-key"><?php echo esc_html($masked_key); ?></span></li>
            </ul>

            <div class="atlt-dashboard-license-pro-container-deactivate-btn">
                <p><?php esc_html_e('Want to deactivate the license for any reason?', $text_domain); ?></p>
                <form method="post" action="<?php echo $admin_url; ?>">
                    <input type="hidden" name="action" value="atlt_deactivate_license" />
                    <?php wp_nonce_field('atlt-license'); ?>
                    <button type="submit" class="deactivate-btn">
                        <?php _e('Deactivate License', $text_domain); ?>
                    </button>
                </form>
            </div>

            <div class="atlt-dashboard-license-pro-container-buttons">
                <p><?php esc_html_e('Want to know more about the license key?', $text_domain); ?></p>
                <div class="btns">
                    <a href="https://my.coolplugins.net/account/?utm_source=atlt_plugin&utm_medium=inside&utm_campaign=store_site&utm_content=license" target="_blank" class="atlt-dashboard-btn">
                        <?php _e('Check Account', $text_domain); ?>
                    </a>
                    <a href="https://locoaddon.com/support/?utm_source=atlt_plugin&utm_medium=inside&utm_campaign=support&utm_content=license" target="_blank" class="atlt-dashboard-btn">
                        <?php _e('Contact Support', $text_domain); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
<?php
}

