class ChromeAiTranslator{static Object=options=>{const selfObject=new this(options);return selfObject.extraData()};constructor(options){this.btnSelector=options.btnSelector||!1,this.btnClass=options.btnClass||!1,this.btnText=options.btnText||`Translate To ${options.targetLanguageLabel}`,this.stringSelector=options.stringSelector||!1,this.progressBarSelector=options.progressBarSelector||!1,this.onStartTranslationProcess=options.onStartTranslationProcess||(()=>{}),this.onComplete=options.onComplete||(()=>{}),this.onLanguageError=options.onLanguageError||(()=>{}),this.onBeforeTranslate=options.onBeforeTranslate||(()=>{}),this.onAfterTranslate=options.onAfterTranslate||(()=>{}),this.sourceLanguage=options.sourceLanguage||"en",this.targetLanguage=options.targetLanguage||"hi",this.targetLanguageLabel=options.targetLanguageLabel||"Hindi",this.onStopTranslation=options.onStopTranslation||(()=>{})}extraData=async()=>{const langSupportedStatus=await ChromeAiTranslator.languageSupportedStatus(this.sourceLanguage,this.targetLanguage,this.targetLanguageLabel);return!0!==langSupportedStatus?(this.onLanguageError(langSupportedStatus),{}):(this.defaultLang=this.targetLanguage,{continueTranslation:this.continueTranslation,stopTranslation:this.stopTranslation,startTranslation:this.startTranslation,reInit:this.reInit,init:this.init})};static languageSupportedStatus=async(sourceLanguage,targetLanguage,targetLanguageLabel)=>{const supportedLanguages=["en","es","ja","ar","bn","de","fr","hi","it","ko","nl","pl","pt","ru","th","tr","vi","zh","zh-hant","bg","cs","da","el","fi","hr","hu","id","iw","lt","no","ro","sk","sl","sv","uk","en-zh"].map(lang=>lang.toLowerCase());if(!window.hasOwnProperty("chrome")||!navigator.userAgent.includes("Chrome")||navigator.userAgent.includes("Edg")){const message=jQuery('<span style="color: #ff4646; margin-top: .5rem; display: inline-block;">The Translator API, which uses local AI models, only works in the Chrome browser. For more details, <a href="https://developer.chrome.com/docs/ai/translator-api" target="_blank">click here</a>.</span>');return message}if(!("translation"in self&&"createTranslator"in self.translation)){const message=jQuery('<span style="color: #ff4646; margin-top: .5rem; display: inline-block;">The Translator AI modal is currently not supported or disabled in your browser. Please enable it. For detailed instructions on how to enable it, <a href="https://developer.chrome.com/docs/ai/translator-api#bypass_language_restrictions_for_local_testing" target="_blank">click here</a>.</span>');return message}if(!supportedLanguages.includes(targetLanguage.toLowerCase())){const message=jQuery(`<span style="color: #ff4646; margin-top: .5rem; display: inline-block;">Unfortunately, the <strong>${targetLanguageLabel} (${targetLanguage})</strong> language is currently not supported by the Local Translator AI modal. Please check and read the docs which languages are currently supported by <a href="https://developer.chrome.com/docs/ai/translator-api#bypass_language_restrictions_for_local_testing" target="_blank">clicking here</a>.</span>`);return message}const status=await translation.canTranslate({sourceLanguage:sourceLanguage,targetLanguage:targetLanguage});if("after-download"===status){const message=jQuery(`<span style="color: #ff4646; margin-top: .5rem; display: inline-block;">Please install the <strong>${targetLanguageLabel} (${targetLanguage})</strong> language pack to proceed.To install the language pack, visit <strong>chrome://on-device-translation-internals</strong>. For further assistance, refer to the <a href="https://developer.chrome.com/docs/ai/translator-api#bypass_language_restrictions_for_local_testing" target="_blank">documentation</a>.</span>`);return message}if("readily"!==status){const message=jQuery(`<span style="color: #ff4646; margin-top: .5rem; display: inline-block;">Please ensure that the <strong>${targetLanguageLabel} (${targetLanguage})</strong> language pack is installed and set as a preferred language in your browser. To install the language pack, visit <strong>chrome://on-device-translation-internals</strong>. For further assistance, refer to the <a href="https://developer.chrome.com/docs/ai/translator-api#bypass_language_restrictions_for_local_testing" target="_blank">documentation</a>.</span>`);return message}return!0};init=async()=>{this.appendBtn(),this.translationStart=!1,this.completedTranslateIndex=0,this.completedCharacterCount=0,this.translateBtnEvents(),this.progressBarSelector&&this.addProgressBar()};appendBtn=()=>{this.translateBtn=jQuery(`<button class="button button-primary${this.btnClass?" "+this.btnClass:""}">${this.btnText}</button>`),jQuery(this.btnSelector).append(this.translateBtn)};translateBtnEvents=e=>{if(!this.btnSelector||0===jQuery(this.btnSelector).length)return this.onLanguageError("The button selector is missing. Please provide a valid selector for the button.");this.translateStringEle=jQuery(this.stringSelector)||jQuery([]),this.translateStatus=!0,this.translateBtn.off("click"),this.translateBtn.prop("disabled",!1),this.translationStart?this.translateStringEle.length>this.completedTranslateIndex+1?this.translateBtn.on("click",()=>{this.onStartTranslationProcess(),this.stringTranslation(this.completedTranslateIndex+1)}):(this.onComplete({translatedStringsCount:this.completedCharacterCount}),this.translateBtn.prop("disabled",!0)):this.translateBtn.on("click",this.startTranslationProcess)};startTranslationProcess=async()=>{this.onStartTranslationProcess();const langCode=this.defaultLang;this.translationStart=!0,this.translateStringEle=jQuery(this.stringSelector),this.totalStringCount=Array.from(this.translateStringEle).map(ele=>ele.innerText.length).reduce((a,b)=>a+b,0),this.translator=await self.translation.createTranslator({sourceLanguage:this.sourceLanguage,targetLanguage:langCode}),this.translateStringEle.length>0&&await this.stringTranslation(this.completedTranslateIndex)};stringTranslation=async index=>{if(!this.translateStatus)return;const ele=this.translateStringEle[index];this.onBeforeTranslate(ele);const orignalText=ele.innerText;let originalString=[];ele.childNodes.length>0&&!ele.querySelector(".notranslate")?ele.childNodes.forEach(child=>{3===child.nodeType&&""!==child.nodeValue.trim()&&originalString.push(child)}):ele.querySelector(".notranslate")&&ele.childNodes.forEach(child=>{3===child.nodeType&&""!==child.nodeValue.trim()&&originalString.push(child)}),originalString.length>0&&await this.stringTranslationBatch(originalString,0),this.completedCharacterCount+=orignalText.length,this.completedTranslateIndex=index,this.progressBarSelector&&this.updateProgressBar(),this.onAfterTranslate(ele),this.translateStringEle.length>index+1&&await this.stringTranslation(this.completedTranslateIndex+1),index===this.translateStringEle.length-1&&(this.translateBtn.prop("disabled",!0),this.onComplete({characterCount:this.completedCharacterCount}),jQuery(this.progressBarSelector).find(".chrome-ai-translator-strings-count").show().find(".totalChars").text(this.completedCharacterCount))};stringTranslationBatch=async(originalString,index)=>{const translatedString=await this.translator.translate(originalString[index].nodeValue);return translatedString&&""!==translatedString&&(originalString[index].nodeValue=translatedString),index<originalString.length-1&&await this.stringTranslationBatch(originalString,index+1),!0};addProgressBar=()=>{if(!document.querySelector("#chrome-ai-translator-modal .chrome-ai-translator_progress_bar")){const progressBar=jQuery('\n                <div class="chrome-ai-translator_progress_bar" style="background-color: #f3f3f3;border-radius: 10px;overflow: hidden;margin: 1.5rem auto; width: 50%;">\n                <div class="chrome-ai-translator_progress" style="overflow: hidden;transition: width .5s ease-in-out; border-radius: 10px;text-align: center;width: 0%;height: 20px;box-sizing: border-box;background-color: #4caf50; color: #fff; font-weight: 600;"></div>\n                </div>\n                <div style="display:none; color: white;" class="chrome-ai-translator-strings-count hidden">\n                    Wahooo! You have saved your valuable time via auto translating \n                    <strong class="totalChars">0</strong> characters using \n                    <strong>\n                        Chrome AI Translator\n                    </strong>\n                </div>\n            ');jQuery(this.progressBarSelector).append(progressBar)}};updateProgressBar=()=>{const progress=this.completedCharacterCount/this.totalStringCount*1e3/10;let decimalValue=progress.toString().split(".")[1]||"";decimalValue=decimalValue.length>0&&"0"!==decimalValue[0]?decimalValue[0]:"";const formattedProgress=parseInt(progress)+`${""!==decimalValue?"."+decimalValue:""}`;jQuery(".chrome-ai-translator_progress").css({width:`${formattedProgress}%`}).text(`${formattedProgress}%`)};stopTranslation=()=>{this.onStopTranslationHandler(),this.translateStatus=!1};onStopTranslationHandler=()=>{this.onStopTranslation()};reInit=()=>{this.translateBtnEvents()};startTranslation=()=>{this.translateStatus=!0,this.startTranslationProcess(this.completedTranslateIndex+1)}}(jQuery=>{let startTime=null;jQuery(document).ready(async()=>{let transalationInitialize=!1;const TranslatorObject=await ChromeAiTranslator.Object({mainWrapperSelector:"#ChromeAiTranslator-widget-model",btnSelector:"#ChromeAiTranslator-widget-model #chrome_ai_translator_element",stringSelector:"#ChromeAiTranslator-widget-model .atlt_string_container table tbody tr td.target.translate",progressBarSelector:"#ChromeAiTranslator-widget-model .atlt_translate_progress",sourceLanguage:"en",targetLanguage:locoConf.conf.locale.lang,targetLanguageLabel:locoConf.conf.locale.label,onStartTranslationProcess:startTransaltion,onComplete:completeTranslation,onLanguageError:languageError,onBeforeTranslate:beforeTranslate,onStopTranslation:onStopTranslation});TranslatorObject.hasOwnProperty("init")&&(jQuery(document).on("click","#ChromeAiTranslator_settings_btn",(function(){transalationInitialize||"function"!=typeof TranslatorObject.init?"function"==typeof TranslatorObject.reInit&&TranslatorObject.reInit():(transalationInitialize=!0,TranslatorObject.init())})),jQuery(window).on("click",event=>{event.target.closest(".modal-content")||event.target.closest("#atlt-dialog")||TranslatorObject.stopTranslation()}),jQuery(document).on("click",".ChromeAiTranslator-widget-header .close",()=>{TranslatorObject.stopTranslation()}))});const startTransaltion=()=>{startTime=Date.now();const stringContainer=jQuery("#ChromeAiTranslator-widget-model .modal-content .atlt_string_container");stringContainer[0].scrollHeight>100&&jQuery("#ChromeAiTranslator-widget-model .atlt_translate_progress").fadeIn("slow")},onStopTranslation=()=>{jQuery("#ChromeAiTranslator-widget-model .atlt_translate_progress").fadeOut("slow")},beforeTranslate=ele=>{const stringContainer=jQuery("#ChromeAiTranslator-widget-model .modal-content .atlt_string_container"),scrollStringContainer=position=>{stringContainer.scrollTop(position)},stringContainerPosition=stringContainer[0].getBoundingClientRect(),eleTopPosition=ele.closest("tr").offsetTop,containerHeight=stringContainer.height();eleTopPosition>containerHeight+stringContainerPosition.y&&scrollStringContainer(eleTopPosition-containerHeight+ele.offsetHeight)},completeTranslation=data=>{const totalTime=Math.round((Date.now()-startTime)/1e3);jQuery("#ChromeAiTranslator-widget-model .atlt_stats").fadeIn("slow");const container=jQuery("#ChromeAiTranslator-widget-model");container.data("translation-time",totalTime),container.data("translation-provider","chrome-ai"),setTimeout(()=>{jQuery("#ChromeAiTranslator-widget-model .atlt_save_strings").prop("disabled",!1),jQuery("#ChromeAiTranslator-widget-model .atlt_translate_progress").fadeOut("slow")},2500)},languageError=message=>{jQuery("#ChromeAiTranslator_settings_btn").next(".beta-button").after(message),jQuery("#ChromeAiTranslator_settings_btn").attr("disabled",!0)}})(jQuery);