<?php
/**
 * Interface Loco_Automatic_Translate_Addon_Pro\AI_Translate\Services\Contracts\Authentication
 */

namespace Loco_Automatic_Translate_Addon_Pro\AI_Translate\Services\Contracts;

use Felix_Arntz\WP_OOP_Plugin_Lib\HTTP\Contracts\Request;

/**
 * Interface for a class representing authentication credentials of a certain kind for an API client.
 */
interface Authentication {

	/**
	 * Authenticates the given request with the credentials.
	 *
	 * @param Request $request The request instance. Updated in place.
	 */
	public function authenticate( Request $request ): void;

	/**
	 * Sets the header name to use to add the credentials to a request.
	 *
	 * @param string $header_name The header name.
	 */
	public function set_header_name( string $header_name ): void;

	/**
	 * Returns the option definitions needed to store the credentials.
	 *
	 * @param string $service_slug The service slug.
	 * @return array<string, array<string, mixed>> The option definitions.
	 */
	public static function get_option_definitions( string $service_slug ): array;
}
