<?php
/**
 * Class Loco_Automatic_Translate_Addon_Pro\AI_Translate\Services\Services_API_Instance
 */

namespace Loco_Automatic_Translate_Addon_Pro\AI_Translate\Services;

use RuntimeException;

/**
 * Class to provide singleton-like access to the canonical Services_API instance.
 */
final class Services_API_Instance {

	/**
	 * Retrieve the canonical Services_API instance.
	 *
	 * @var Services_API|null The canonical Services_API instance.
	 */
	private static $instance;

	/**
	 * Retrieves the canonical Services_API instance.
	 *
	 * @return Services_API The canonical Services_API instance.
	 *
	 * @throws RuntimeException Thrown if the method is called too early when no instance has been set before.
	 */
	public static function get(): Services_API {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new Services_API();
		}

		return self::$instance;
	}

	/**
	 * Sets the canonical Services_API instance.
	 *
	 * @param Services_API $instance The canonical Services_API instance.
	 *
	 * @throws RuntimeException Thrown if the method is called after the instance has already been set.
	 */
	public static function set( Services_API $instance ): void {
		if ( isset( self::$instance ) ) {
			throw new RuntimeException(
				esc_html__( 'Cannot set Services_API instance after it has already been set.', 'ai-services' )
			);
		}

		self::$instance = $instance;
	}
}
