<?php
/**
 *
 * The framework's functions and definitions
 */
update_option( 'woodmart_token', true );
        update_option( 'woodmart_is_activated', true );
        update_option( 'woodmart_purchase_code', 'valid' );
        
define( 'WOODMART_THEME_DIR', get_template_directory_uri() );
define( 'WOODMART_THEMEROOT', get_template_directory() );
define( 'WOODMART_IMAGES', WOODMART_THEME_DIR . '/images' );
define( 'WOODMART_SCRIPTS', WOODMART_THEME_DIR . '/js' );
define( 'WOODMART_STYLES', WOODMART_THEME_DIR . '/css' );
define( 'WOODMART_FRAMEWORK', '/inc' );
define( 'WOODMART_DUMMY', WOODMART_THEME_DIR . '/inc/dummy-content' );
define( 'WOODMART_CLASSES', WOODMART_THEMEROOT . '/inc/classes' );
define( 'WOODMART_CONFIGS', WOODMART_THEMEROOT . '/inc/configs' );
define( 'WOODMART_HEADER_BUILDER', WOODMART_THEME_DIR . '/inc/modules/header-builder' );
define( 'WOODMART_ASSETS', WOODMART_THEME_DIR . '/inc/admin/assets' );
define( 'WOODMART_ASSETS_IMAGES', WOODMART_ASSETS . '/images' );
define( 'WOODMART_API_URL', 'https://xtemos.com/wp-json/xts/v1/' );
define( 'WOODMART_DEMO_URL', 'https://woodmart.xtemos.com/' );
define( 'WOODMART_PLUGINS_URL', WOODMART_DEMO_URL . 'plugins/' );
define( 'WOODMART_DUMMY_URL', WOODMART_DEMO_URL . 'dummy-content-new/' );
define( 'WOODMART_TOOLTIP_URL', WOODMART_DEMO_URL . 'theme-settings-tooltips/' );
define( 'WOODMART_SLUG', 'woodmart' );
define( 'WOODMART_CORE_VERSION', '1.1.2' );
define( 'WOODMART_WPB_CSS_VERSION', '1.0.2' );

if ( ! function_exists( 'woodmart_load_classes' ) ) {
	function woodmart_load_classes() {
		$classes = array(
			'class-singleton.php',
			'class-api.php',
			'class-config.php',
			'class-layout.php',
			'class-autoupdates.php',
			'class-activation.php',
			'class-notices.php',
			'class-theme.php',
			'class-registry.php',
		);

		foreach ( $classes as $class ) {
			require WOODMART_CLASSES . DIRECTORY_SEPARATOR . $class;
		}
	}
}

woodmart_load_classes();

new XTS\Theme();

define( 'WOODMART_VERSION', woodmart_get_theme_info( 'Version' ) );



/**
 * Ocultar preços no loop da Loja e na Pesquisa (Woodmart Child)
 */
add_filter('woocommerce_get_price_html', function ($price, $product) {
    // Não altera no admin ou em chamadas internas críticas
    if (is_admin() && !wp_doing_ajax()) {
        return $price;
    }

    // Alvos: Loja/arquivos de produto e resultados de pesquisa
    $is_shop_archive = is_post_type_archive('product') || is_shop() || is_product_taxonomy(); // categorias/tags de produto
    $is_product_search = is_search();

    if ($is_shop_archive || $is_product_search) {
        return ''; // remove HTML do preço
    }

    return $price;
}, 10, 2);

/**
 * Opcional: evita que o WooCommerce injete schema de preço (rich results)
 * nas mesmas páginas, para não aparecer preço em snippets do Google.
 */
add_filter('woocommerce_structured_data_product', function ($markup, $product) {
    if ((is_post_type_archive('product') || is_shop() || is_product_taxonomy() || is_search())
        && is_array($markup)
    ) {
        unset($markup['offers']); // remove bloco de ofertas/preço do schema.org
    }
    return $markup;
}, 10, 2);

/**
 * (Extra de compatibilidade) Remove o hook de preço do loop — útil se algum template ignorar o filtro.
 */
add_action('wp', function () {
    if (is_post_type_archive('product') || is_shop() || is_product_taxonomy() || is_search()) {
        remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10);
    }
});

